/*
 * Decompiled with CFR 0.152.
 */
package com.quickheal.eps.helper;

import com.quickheal.eps.helper.Base64Url;
import com.quickheal.eps.helper.Crypt;
import com.quickheal.eps.helper.UTF8;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhpOp {
    @Autowired
    private Crypt mObjCrypt;
    @Autowired
    private UTF8 mObjUTF8;
    @Autowired
    private Base64Url mObjBase64Url;

    String transformPhpCommand(String strPhpCommand, boolean bMakeSecure, String m_strKey) {
        boolean bIsKeyValue;
        String strTmpCommand;
        String SEP_KEY_VALUE = "=";
        int SEP_PHP_ARGUMENT = 63;
        String SEP_KEYVALUE_PAIR = "&";
        if (null == strPhpCommand) {
            return null;
        }
        StringBuilder strTransformPhpCommand = new StringBuilder();
        int iIndex = strPhpCommand.lastIndexOf(63);
        if (-1 != iIndex) {
            strTransformPhpCommand.append(strPhpCommand.substring(0, iIndex + 1));
            strTmpCommand = strPhpCommand.substring(++iIndex);
        } else {
            strTmpCommand = strPhpCommand;
        }
        int iBeginIndex = 0;
        String strTemp = strTmpCommand;
        int iEndIndex = strTemp.indexOf("&");
        boolean bl = bIsKeyValue = -1 != iEndIndex;
        while (true) {
            String strValue;
            String strField;
            String strToken;
            if (-1 != iEndIndex) {
                strToken = strTemp.substring(iBeginIndex, iEndIndex);
                strTemp = strTemp.substring(iEndIndex + 1);
            } else {
                strToken = strTemp;
            }
            iIndex = strToken.indexOf("=");
            if (-1 == iIndex) {
                strField = strToken;
                strValue = "";
            } else {
                strField = strToken.substring(0, iIndex);
                strValue = strToken.substring(iIndex + 1);
            }
            strField = bMakeSecure ? this.convertToSecureString(strField, m_strKey) : this.convertToPlainString(strField, m_strKey);
            if (null == strField) {
                return null;
            }
            strTransformPhpCommand.append(strField).append("=");
            if (strValue.length() > 0) {
                strValue = bMakeSecure ? this.convertToSecureString(strValue, m_strKey) : this.convertToPlainString(strValue, m_strKey);
                if (null == strValue) {
                    return null;
                }
                strTransformPhpCommand.append(strValue);
            }
            if (!bIsKeyValue) break;
            iEndIndex = strTemp.indexOf("&");
            strTransformPhpCommand.append("&");
            if (-1 != iEndIndex) continue;
            bIsKeyValue = false;
        }
        return strTransformPhpCommand.toString();
    }

    String convertToSecurePhpCommand(String strPhpCommand, String m_strKey) {
        return this.transformPhpCommand(strPhpCommand, true, m_strKey);
    }

    public String convertToSecureString(String strData, String m_strKey) {
        if (null == strData) {
            return null;
        }
        byte[] byarrData = this.mObjUTF8.encode(strData);
        if (byarrData.length == 0) {
            return null;
        }
        if ((byarrData = this.mObjCrypt.encrypt(byarrData, m_strKey)).length == 0) {
            return null;
        }
        if ((byarrData = this.mObjBase64Url.encode(byarrData)).length == 0) {
            return null;
        }
        try {
            return new String(byarrData, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    String convertToSecureKeyValuePair(String strKey, String strValue, String m_strKey) {
        String SEP_KEY_VALUE = "=";
        if (null == strKey || null == strValue) {
            return null;
        }
        String strSecureKey = this.convertToSecureString(strKey, m_strKey);
        if (null == strSecureKey) {
            return null;
        }
        String strSecureValue = this.convertToSecureString(strValue, m_strKey);
        if (null == strSecureValue) {
            return null;
        }
        return strSecureKey + "=" + strSecureValue;
    }

    String convertToPlainPhpCommand(String strPhpCommand, String m_strKey) {
        return this.transformPhpCommand(strPhpCommand, false, m_strKey);
    }

    public String convertToPlainString(String strData, String m_strKey) {
        if (null == strData) {
            return null;
        }
        byte[] byarrData = this.mObjBase64Url.Decode(strData.getBytes());
        if (null == byarrData) {
            return null;
        }
        if ((byarrData = this.mObjCrypt.decrypt(byarrData, m_strKey)).length == 0) {
            return null;
        }
        return this.mObjUTF8.decode(byarrData);
    }
}

