/*
 * Decompiled with CFR 0.152.
 */
package com.quickheal.eps.helper;

import java.io.UnsupportedEncodingException;
import org.springframework.stereotype.Service;

@Service
public class Base64Url {
    private static final String ISO_8859_1 = "ISO-8859-1";

    public byte[] encode(byte[] byarrData) {
        String strData;
        if (null == byarrData) {
            return new byte[0];
        }
        int iLength = byarrData.length;
        if (iLength <= 0) {
            return new byte[0];
        }
        try {
            strData = new String(byarrData, ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
        StringBuilder strEncode = new StringBuilder();
        int iPos = 0;
        int iIndex = 0;
        while (iPos < iLength) {
            char ch1 = strData.charAt(iPos);
            char ch2 = '\u0000';
            if (iPos + 1 < iLength) {
                ch2 = strData.charAt(iPos + 1);
            }
            char ch3 = '\u0000';
            if (iPos + 2 < iLength) {
                ch3 = strData.charAt(iPos + 2);
            }
            char ch4 = (char)(ch1 >> 2);
            char ch5 = (char)((ch1 & 3) << 4 | ch2 >> 4);
            char ch6 = (char)((ch2 & 0xF) << 2 | ch3 >> 6);
            char ch7 = (char)(ch3 & 0x3F);
            strEncode.insert(iIndex, this.GetBase64Symbol(ch4));
            strEncode.insert(iIndex + 1, this.GetBase64Symbol(ch5));
            if (iPos + 1 < iLength) {
                strEncode.insert(iIndex + 2, this.GetBase64Symbol(ch6));
            } else {
                strEncode.insert(iIndex + 2, '$');
            }
            if (iPos + 2 < iLength) {
                strEncode.insert(iIndex + 3, this.GetBase64Symbol(ch7));
            } else {
                strEncode.insert(iIndex + 3, '$');
            }
            iPos += 3;
            iIndex += 4;
        }
        return strEncode.toString().getBytes();
    }

    public byte[] Decode(byte[] byarrData) {
        StringBuilder strDecode;
        String strData;
        int iPos = -1;
        int iIndex = -1;
        if (null == byarrData) {
            return new byte[0];
        }
        int iLength = byarrData.length;
        if (iLength <= 0) {
            return new byte[0];
        }
        boolean bRet = this.IsBase64(byarrData);
        if (!bRet) {
            return new byte[0];
        }
        try {
            strData = new String(byarrData, ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
        try {
            strDecode = new StringBuilder(0);
            iPos = 0;
            iIndex = 0;
            while (iPos < iLength) {
                char ch1 = strData.charAt(iPos);
                char ch2 = 'A';
                if (iPos + 1 < iLength) {
                    ch2 = strData.charAt(iPos + 1);
                }
                char ch3 = 'A';
                if (iPos + 2 < iLength) {
                    ch3 = strData.charAt(iPos + 2);
                }
                char ch4 = 'A';
                if (iPos + 3 < iLength) {
                    ch4 = strData.charAt(iPos + 3);
                }
                char uch1 = this.GetASCIISymbol(ch1);
                char uch2 = this.GetASCIISymbol(ch2);
                char uch3 = this.GetASCIISymbol(ch3);
                char uch4 = this.GetASCIISymbol(ch4);
                strDecode.insert(iIndex, (char)(uch1 << 2 | uch2 >> 4));
                if (ch3 != '$') {
                    strDecode.insert(iIndex + 1, (char)((uch2 & 0xF) << 4 | uch3 >> 2));
                }
                if (ch4 != '$') {
                    strDecode.insert(iIndex + 2, (char)((uch3 & 3) << 6 | uch4));
                }
                iPos += 4;
                iIndex += 3;
            }
        }
        catch (Exception e) {
            return new byte[0];
        }
        try {
            return strDecode.toString().getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    boolean IsBase64(byte[] byarrData) {
        if (null == byarrData) {
            return false;
        }
        int iLength = byarrData.length;
        for (int iPos = 0; iPos < iLength; ++iPos) {
            if (!this.checkWhetherContainsOtherThanAlphabet(byarrData, iPos) || !this.checkWhetherContainsOtherThanDigit(byarrData, iPos) || !this.checkWhetherContainsSpecialCharacters(byarrData, iPos)) continue;
            return false;
        }
        return true;
    }

    char GetBase64Symbol(char chSymbol) {
        if (chSymbol < '\u001a') {
            return (char)(65 + chSymbol);
        }
        if (chSymbol < '4') {
            return (char)(97 + (chSymbol - 26));
        }
        if (chSymbol < '>') {
            return (char)(48 + (chSymbol - 52));
        }
        if ('>' == chSymbol) {
            return '_';
        }
        return '!';
    }

    char GetASCIISymbol(char chSymbol) {
        if (chSymbol >= 'A' && chSymbol <= 'Z') {
            return (char)(chSymbol - 65);
        }
        if (chSymbol >= 'a' && chSymbol <= 'z') {
            return (char)(chSymbol - 97 + 26);
        }
        if (chSymbol >= '0' && chSymbol <= '9') {
            return (char)(chSymbol - 48 + 52);
        }
        if ('_' == chSymbol) {
            return '>';
        }
        return '?';
    }

    boolean checkWhetherContainsOtherThanAlphabet(byte[] byarrData, int iPos) {
        return !(byarrData[iPos] >= 65 && byarrData[iPos] <= 90 || byarrData[iPos] >= 97 && byarrData[iPos] <= 122);
    }

    boolean checkWhetherContainsOtherThanDigit(byte[] byarrData, int iPos) {
        return byarrData[iPos] < 48 || byarrData[iPos] > 57;
    }

    boolean checkWhetherContainsSpecialCharacters(byte[] byarrData, int iPos) {
        return 95 != byarrData[iPos] && 33 != byarrData[iPos] && 36 != byarrData[iPos];
    }
}

