/*
 * Decompiled with CFR 0.152.
 */
package com.quickheal.eps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.quickheal.eps.config.OfflineActProperties;
import com.quickheal.eps.helper.EncryptDecryptUtil;
import com.quickheal.eps.helper.PhpOp;
import com.quickheal.eps.model.ActivationOnprem;
import com.quickheal.eps.model.ActivationResponseOnprem;
import com.quickheal.eps.model.EnumServerType;
import com.quickheal.eps.model.LicenseSync;
import com.quickheal.eps.model.OfflineActivationDTO;
import com.quickheal.eps.model.ReActivationOnprem;
import com.quickheal.eps.model.UpdateSSR;
import com.quickheal.eps.model.UpdateSSRResponse;
import com.quickheal.eps.model.Validation;
import com.quickheal.eps.model.ValidationResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@SpringBootApplication
@EnableAutoConfiguration
@Component
public class QhEpsOfflineActivationToolApplication
implements CommandLineRunner {
    @Autowired
    private OfflineActProperties offlineActProperties;
    @Autowired
    private PhpOp phpOp;
    ObjectMapper objectMapper = new ObjectMapper();
    public static final String OFFLINE_ACTIVATION_DATA_FILE_NAME = "offlineactivation.txt";
    public static final String SITE_LICENSE_INFO_FILE_NAME = "sitelicenseinfo.txt";
    public static final String OFFLINE_ACTIVATION_RESPONSE_FILE_NAME = "ofresponse.txt";
    public static Scanner scanner = new Scanner(System.in);
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_BLUE = "\u001b[34m";

    public static void main(String[] args) {
        SpringApplication.run(QhEpsOfflineActivationToolApplication.class, (String[])args);
    }

    /*
     * Unable to fully structure code
     */
    public void run(String ... args) throws Exception {
        call = true;
        while (call) {
            System.out.println("Enter the productkey : ");
            System.out.println("\u001b[34mType Product Key with format XXXXX-XXXXX-XXXXX-XXXXX, and hit [Enter]\u001b[0m");
            productkey = this.getProductKey();
            System.out.println("\u001b[34m\nEnter the server type:");
            System.out.println("1. EPP Server \n2. Control Center Server (Multisite Mode) \n3. Site Server (Multisite Mode)\u001b[0m");
            serverType = QhEpsOfflineActivationToolApplication.scanner.nextInt() - 1;
            System.out.println("\u001b[34m\nSelect the operation you want to perform and hit [Enter]");
            System.out.println("1. Activation \n2. License Sync\u001b[0m");
            operation = QhEpsOfflineActivationToolApplication.scanner.nextInt();
            QhEpsOfflineActivationToolApplication.scanner.close();
            objectMapper = new ObjectMapper();
            stringBuilder = new StringBuilder();
            try {
                bufferedReader = new BufferedReader(new FileReader("offlineactivation.txt"));
                fileContent = null;
                while ((fileContent = bufferedReader.readLine()) != null) {
                    stringBuilder.append(fileContent);
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                System.out.println("offlineactivation.txtfile not found");
                break;
            }
            content = stringBuilder.toString();
            okgActivation = new ActivationOnprem();
            try {
                okgActivation = (ActivationOnprem)objectMapper.readValue(EncryptDecryptUtil.decrypt((String)content), ActivationOnprem.class);
            }
            catch (Exception e) {
                System.out.println("Exception : " + e);
            }
            harwareID = okgActivation.getOsInfo().getINSTNO();
            macidList = new ArrayList<String>();
            macidList.add(okgActivation.getOsInfo().getMACID1());
            macidList.add(okgActivation.getOsInfo().getMACID2());
            macidList.add(okgActivation.getOsInfo().getMACID3());
            macidList.removeIf((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isNull(java.lang.Object ), (Ljava/lang/String;)Z)());
            switch (operation) {
                case 1: {
                    validationResponse = this.validateProductKey(productkey, harwareID, this.offlineActProperties.getOnPremTenantId(), this.offlineActProperties.getEpsngVersion(), macidList, okgActivation.getProductInfo().getTYPE(), okgActivation.getProductInfo().getSiteServerId());
                    if (ObjectUtils.isEmpty((Object)validationResponse.getResponseCode())) {
                        System.out.println("Validation response is null");
                        break;
                    }
                    if ("104".equals(validationResponse.getResponseCode())) {
                        intProductType = this.getOnpremProductType(validationResponse.getProductInfo().getProductType());
                        okgActivation.setProductKey(productkey);
                        okgActivation.getProductInfo().setLicenseType(validationResponse.getProductInfo().getLicenseType());
                        okgActivation.getProductInfo().setCopyType(Integer.toString(intProductType));
                        okgActivation.getProductInfo().setProductType(this.getProductTypeOnprem(intProductType));
                        if (1 == validationResponse.getFeaturesInfo().getFeatures().getMultisite() && Integer.toString(EnumServerType.AGGREGATOR.getServerType()).equals(okgActivation.getProductInfo().getTYPE())) {
                            okgActivation.getProductInfo().setTYPE(Integer.toString(EnumServerType.AGGREGATOR.getServerType()));
                            okgActivation.getProductInfo().setSiteServerId("");
                        } else if (1 == validationResponse.getFeaturesInfo().getFeatures().getMultisite() && !Integer.toString(EnumServerType.AGGREGATOR.getServerType()).equals(okgActivation.getProductInfo().getTYPE())) {
                            okgActivation.getProductInfo().setTYPE(Integer.toString(EnumServerType.SITE_SERVER.getServerType()));
                        } else if (0 == validationResponse.getFeaturesInfo().getFeatures().getMultisite()) {
                            okgActivation.getProductInfo().setTYPE(Integer.toString(EnumServerType.NORMAL_EPS.getServerType()));
                            okgActivation.getProductInfo().setSiteServerId("");
                        }
                        try {
                            activationResponse = this.activateLicense(okgActivation);
                            if (activationResponse.getResponseCode().equals("200")) {
                                this.setActivationResponse(activationResponse, okgActivation, validationResponse);
                                System.out.println("Seqrite Endpoint Protection has been activated successfully.");
                                break;
                            }
                            this.getErrorStringForConsole(activationResponse.getResponseCode());
                            call = false;
                        }
                        catch (Exception e) {
                            System.out.println("Error in Activation");
                        }
                        break;
                    }
                    if ("200".equals(validationResponse.getResponseCode())) {
                        intProductType = this.getOnpremProductType(validationResponse.getProductInfo().getProductType());
                        okgActivation.setProductKey(productkey);
                        okgActivation.getProductInfo().setLicenseType(validationResponse.getProductInfo().getLicenseType());
                        okgActivation.getProductInfo().setCopyType(Integer.toString(intProductType));
                        okgActivation.getProductInfo().setProductType(this.getProductTypeOnprem(intProductType));
                        reActivationOnprem = this.getReactivationDTO(okgActivation, productkey, macidList, validationResponse);
                        try {
                            activationResponse = this.reActivateLicense(reActivationOnprem);
                            if (activationResponse.getResponseCode().equals("200")) {
                                this.setActivationResponse(activationResponse, okgActivation, validationResponse);
                                System.out.println("Seqrite Endpoint Protection has been reactivated successfully.");
                                break;
                            }
                            this.getErrorStringForConsole(activationResponse.getResponseCode());
                            call = false;
                        }
                        catch (Exception e) {
                            System.out.println("Error in ReActivation");
                        }
                        break;
                    }
                    this.getErrorStringForConsole(validationResponse.getResponseCode());
                    call = false;
                    break;
                }
                case 2: {
                    okgActivation.setProductKey(productkey);
                    okgActivation.getProductInfo().setTYPE(Integer.toString(serverType));
                    licenseSync = this.createSyncPayload(okgActivation, macidList);
                    try {
                        syncResponse = this.licenseSync(licenseSync);
                        if (!syncResponse.getResponseCode().equals("200")) ** GOTO lbl110
                        this.setActivationResponse(syncResponse, okgActivation, null);
                        System.out.println("Seqrite Endpoint Protection has been synced successfully.");
                        ** GOTO lbl116
lbl110:
                        // 1 sources

                        this.getErrorStringForConsole(syncResponse.getResponseCode());
                        call = false;
                    }
                    catch (Exception e) {
                        System.out.println("Error in License Sync");
                    }
                    break;
lbl116:
                    // 1 sources

                    if (EnumServerType.AGGREGATOR.getServerType() != serverType) break;
                    try {
                        bufferedReader = new BufferedReader(new FileReader("sitelicenseinfo.txt"));
                        fileContent = null;
                        stringBuilder.setLength(0);
                        while ((fileContent = bufferedReader.readLine()) != null) {
                            stringBuilder.append(fileContent);
                        }
                        bufferedReader.close();
                    }
                    catch (Exception e) {
                        System.out.println("sitelicenseinfo.txt file not found");
                        break;
                    }
                    content = stringBuilder.toString();
                    if (content.isEmpty()) break;
                    updateSSRList = (List)objectMapper.readValue(EncryptDecryptUtil.decrypt((String)content), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    for (UpdateSSR updateSSR : updateSSRList) {
                        this.updateSSR(updateSSR);
                    }
                    break;
                }
                default: {
                    System.out.println("\u001b[31mInvalid Input\u001b[0m");
                }
            }
            call = false;
        }
        System.exit(0);
    }

    private String getProductKey() {
        String productKey = scanner.nextLine();
        productKey = productKey.replaceAll("-", " ");
        productKey = productKey.replaceAll("\\s", "");
        return productKey;
    }

    private Validation createValidationRequestPayload(String productKey, String hardwareId, String tenantId, String epsngVersion, List<String> macidList, String serverType, String siteServerId) {
        Validation productKeyValidation = new Validation();
        productKeyValidation.setProductKey(productKey);
        productKeyValidation.setEPSNG_VER(epsngVersion);
        productKeyValidation.setINSTNO(hardwareId);
        if (!macidList.isEmpty()) {
            int size = macidList.size();
            int count = 0;
            for (String macid : macidList) {
                if (++count == 1 & count <= size) {
                    productKeyValidation.setMACID1(macid);
                    productKeyValidation.setMACID2("");
                    productKeyValidation.setMACID3("");
                }
                if (count == 2 & count <= size) {
                    productKeyValidation.setMACID2(macid);
                    productKeyValidation.setMACID3("");
                }
                if (!(count == 3 & count <= size)) continue;
                productKeyValidation.setMACID3(macid);
            }
        }
        productKeyValidation.setTYPE(serverType);
        productKeyValidation.setSiteServerId(siteServerId);
        return productKeyValidation;
    }

    public ValidationResponse validateProductKey(String productKey, String harwareId, String tenantId, String epsngVersion, List<String> macIDs, String serverType, String siteServerId) throws JsonMappingException, JsonProcessingException {
        ValidationResponse validationResponse = this.validateProductKeyOnPrem(this.createValidationRequestPayload(productKey, harwareId, tenantId, epsngVersion, macIDs, serverType, siteServerId));
        return validationResponse;
    }

    private ValidationResponse validateProductKeyOnPrem(Validation validation) throws JsonMappingException, JsonProcessingException {
        ValidationResponse validationResponse = new ValidationResponse();
        try {
            String encryptedRequestPayload = this.phpOp.convertToSecureString(this.objectMapper.writeValueAsString((Object)validation), this.offlineActProperties.getCryptActKey());
            String validateKeyApiResponse = this.validateKey(encryptedRequestPayload);
            String response = this.phpOp.convertToPlainString(validateKeyApiResponse, this.offlineActProperties.getCryptActKey());
            this.objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            validationResponse = (ValidationResponse)this.objectMapper.readValue(response, ValidationResponse.class);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        return validationResponse;
    }

    private String validateKey(String requestPayload) {
        String response = null;
        RestTemplate restTemplate = new RestTemplate();
        try {
            response = (String)restTemplate.postForObject(this.offlineActProperties.getOkgValidateKeyOnpremApi(), (Object)requestPayload, String.class, new Object[0]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return response;
    }

    public ActivationResponseOnprem activateLicense(ActivationOnprem activation) {
        ActivationResponseOnprem activationResponse = null;
        String responseOfOkgCall = "";
        String encryptedRequestPayload = null;
        try {
            encryptedRequestPayload = this.phpOp.convertToSecureString(this.objectMapper.writeValueAsString((Object)activation), this.offlineActProperties.getCryptActKey());
        }
        catch (JsonProcessingException e1) {
            System.out.println("Error in parsing: " + (Object)((Object)e1));
        }
        RestTemplate restTemplate = new RestTemplate();
        try {
            responseOfOkgCall = (String)restTemplate.postForObject(this.offlineActProperties.getOkgActivationOnpremApi(), (Object)encryptedRequestPayload, String.class, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("activateLicense: " + e);
        }
        String response = this.phpOp.convertToPlainString(responseOfOkgCall, this.offlineActProperties.getCryptActKey());
        try {
            this.objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            activationResponse = (ActivationResponseOnprem)this.objectMapper.readValue(response, ActivationResponseOnprem.class);
        }
        catch (IOException e) {
            System.out.println("activateLicense: " + e);
        }
        return activationResponse;
    }

    public ReActivationOnprem getReactivationDTO(ActivationOnprem activationOnprem, String productKey, List<String> macidList, ValidationResponse validationResponse) {
        ReActivationOnprem reActivationOnprem = new ReActivationOnprem();
        reActivationOnprem.setProductKey(productKey);
        reActivationOnprem.setUserInfo(activationOnprem.getUserInfo());
        reActivationOnprem.setOS("CentOS");
        reActivationOnprem.setOSSP("1");
        reActivationOnprem.setOSLANG("English");
        reActivationOnprem.setINOS(activationOnprem.getOsInfo().getINSTNO());
        reActivationOnprem.setQLANG("English");
        reActivationOnprem.setEPSNG_VER(this.offlineActProperties.getEpsngVersion());
        if (1 == validationResponse.getFeaturesInfo().getFeatures().getMultisite() && Integer.toString(EnumServerType.AGGREGATOR.getServerType()).equals(activationOnprem.getProductInfo().getTYPE())) {
            reActivationOnprem.setTYPE(Integer.toString(EnumServerType.AGGREGATOR.getServerType()));
            reActivationOnprem.setSiteServerId("");
        } else if (1 == validationResponse.getFeaturesInfo().getFeatures().getMultisite() && !Integer.toString(EnumServerType.AGGREGATOR.getServerType()).equals(activationOnprem.getProductInfo().getTYPE())) {
            reActivationOnprem.setTYPE(Integer.toString(EnumServerType.SITE_SERVER.getServerType()));
            reActivationOnprem.setSiteServerId(activationOnprem.getProductInfo().getSiteServerId());
        } else if (0 == validationResponse.getFeaturesInfo().getFeatures().getMultisite()) {
            reActivationOnprem.setTYPE(Integer.toString(EnumServerType.NORMAL_EPS.getServerType()));
            reActivationOnprem.setSiteServerId("");
        }
        if (!macidList.isEmpty()) {
            int size = macidList.size();
            int count = 0;
            for (String macid : macidList) {
                if (++count == 1 & count <= size) {
                    reActivationOnprem.setMACID1(macid);
                    reActivationOnprem.setMACID2("");
                    reActivationOnprem.setMACID3("");
                }
                if (count == 2 & count <= size) {
                    reActivationOnprem.setMACID2(macid);
                    reActivationOnprem.setMACID3("");
                }
                if (!(count == 3 & count <= size)) continue;
                reActivationOnprem.setMACID3(macid);
            }
        }
        return reActivationOnprem;
    }

    public ActivationResponseOnprem reActivateLicense(ReActivationOnprem reActivation) {
        ActivationResponseOnprem reActivationResponse = null;
        String encryptedRequestPayload = null;
        String responseOfOkgCall = "";
        try {
            encryptedRequestPayload = this.phpOp.convertToSecureString(this.objectMapper.writeValueAsString((Object)reActivation), this.offlineActProperties.getCryptActKey());
        }
        catch (JsonProcessingException e1) {
            System.out.println("Error in parsing: " + (Object)((Object)e1));
        }
        RestTemplate restTemplate = new RestTemplate();
        try {
            responseOfOkgCall = (String)restTemplate.postForObject(this.offlineActProperties.getOkgReactivationOnpremApi(), (Object)encryptedRequestPayload, String.class, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("activateLicense: " + e);
        }
        String response = this.phpOp.convertToPlainString(responseOfOkgCall, this.offlineActProperties.getCryptActKey());
        try {
            this.objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            reActivationResponse = (ActivationResponseOnprem)this.objectMapper.readValue(response, ActivationResponseOnprem.class);
        }
        catch (IOException e) {
            System.out.println("activateLicense: " + e);
        }
        return reActivationResponse;
    }

    private LicenseSync createSyncPayload(ActivationOnprem okgActivation, List<String> macidList) {
        LicenseSync licenseSync = new LicenseSync();
        licenseSync.setProductKey(okgActivation.getProductKey());
        if (!macidList.isEmpty()) {
            int size = macidList.size();
            int count = 0;
            for (String macid : macidList) {
                if (++count == 1 & count <= size) {
                    licenseSync.setMACID1(macid);
                    licenseSync.setMACID2("");
                    licenseSync.setMACID3("");
                }
                if (count == 2 & count <= size) {
                    licenseSync.setMACID2(macid);
                    licenseSync.setMACID3("");
                }
                if (!(count == 3 & count <= size)) continue;
                licenseSync.setMACID3(macid);
            }
        }
        licenseSync.setINSTNO(okgActivation.getOsInfo().getINSTNO());
        licenseSync.setEPSNG_VER(okgActivation.getProductInfo().getEpsngVersion());
        licenseSync.setTYPE(okgActivation.getProductInfo().getTYPE());
        licenseSync.setSiteServerId(okgActivation.getProductInfo().getSiteServerId());
        return licenseSync;
    }

    private ActivationResponseOnprem licenseSync(LicenseSync licenseSync) {
        ActivationResponseOnprem reActivationResponse = null;
        String encryptedRequestPayload = null;
        String responseOfOkgCall = "";
        try {
            encryptedRequestPayload = this.phpOp.convertToSecureString(this.objectMapper.writeValueAsString((Object)licenseSync), this.offlineActProperties.getCryptActKey());
        }
        catch (JsonProcessingException e1) {
            System.out.println("Error in parsing: " + (Object)((Object)e1));
        }
        RestTemplate restTemplate = new RestTemplate();
        try {
            responseOfOkgCall = (String)restTemplate.postForObject(this.offlineActProperties.getLicenseSynchOnpremApi(), (Object)encryptedRequestPayload, String.class, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("licenseSync: " + e);
        }
        String response = this.phpOp.convertToPlainString(responseOfOkgCall, this.offlineActProperties.getCryptActKey());
        try {
            this.objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            reActivationResponse = (ActivationResponseOnprem)this.objectMapper.readValue(response, ActivationResponseOnprem.class);
        }
        catch (IOException e) {
            System.out.println("licenseSync: " + e);
        }
        return reActivationResponse;
    }

    private void setActivationResponse(ActivationResponseOnprem activationResponse, ActivationOnprem activationOnprem, ValidationResponse validationResponse) throws ParseException {
        String productType = "";
        if (null != validationResponse && null != validationResponse.getProductInfo() && null != validationResponse.getProductInfo().getProductType()) {
            productType = validationResponse.getProductInfo().getProductType();
        } else if (null != activationResponse && null != activationResponse.getProductInfo() && null != activationResponse.getProductInfo().getProductType()) {
            productType = activationResponse.getProductInfo().getProductType();
        } else if (null != activationOnprem && null != activationOnprem.getProductInfo() && null != activationOnprem.getProductInfo().getProductType()) {
            productType = activationOnprem.getProductInfo().getProductType();
        }
        if (!Objects.isNull(validationResponse)) {
            activationResponse.getProductInfo().setProductName(validationResponse.getProductInfo().getProductName());
            activationResponse.getProductInfo().setProductType(validationResponse.getProductInfo().getProductType());
            activationResponse.getProductInfo().setLicenseType(validationResponse.getProductInfo().getLicenseType());
            activationResponse.getProductInfo().setPurchaseFrom(validationResponse.getProductInfo().getPurchaseFrom());
            activationResponse.getProductInfo().setSubscriptionPeriod(validationResponse.getProductInfo().getSubscriptionPeriod());
            activationResponse.setUserInfo(validationResponse.getUserInfo());
        }
        OfflineActivationDTO offlineActivationDTO = new OfflineActivationDTO();
        offlineActivationDTO.setSynchResponse(activationResponse);
        offlineActivationDTO.setOsInfo(activationOnprem.getOsInfo());
        offlineActivationDTO.setProductKey(activationOnprem.getProductKey());
        offlineActivationDTO.setProductEdition(this.getOnpremProductType(productType));
        offlineActivationDTO.setProductType(this.getOnpremProductType(productType));
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(OFFLINE_ACTIVATION_RESPONSE_FILE_NAME));){
            String offlineActivationData = this.objectMapper.writeValueAsString((Object)offlineActivationDTO);
            dataOutputStream.writeBytes(EncryptDecryptUtil.encrypt((String)offlineActivationData));
        }
        catch (Exception e) {
            System.out.println("Error in creating file : " + e);
            System.exit(0);
        }
    }

    public void getErrorStringForConsole(String responseCode) {
        if ("99".equals(responseCode)) {
            System.out.println("\u001b[31mUnable to process your request. Please check your internet connection and try again.\u001b[0m");
        } else if ("100".equals(responseCode)) {
            System.out.println("\u001b[31mInvalid Product Key. Please provide correct Product Key to continue.\u001b[0m");
        } else if ("102".equals(responseCode)) {
            System.out.println("\u001b[31mProduct Key blocked.\u001b[0m");
        } else if ("103".equals(responseCode)) {
            System.out.println("\u001b[31mProduct Key is not registered.\u001b[0m");
        } else if ("114".equals(responseCode)) {
            System.out.println("\u001b[31mProduct Key and Product mismatch.\u001b[0m");
        } else if ("120".equals(responseCode)) {
            System.out.println("\u001b[31mProduct Key expired.\u001b[0m");
        } else if ("116".equals(responseCode)) {
            System.out.println("\u001b[31mYou have exceeded the limit of reactivation attempts.\u001b[0m");
        } else if ("98".equals(responseCode)) {
            System.out.println("\u001b[31mActivation failed due to authentication error.\u001b[0m");
        } else if ("118".equals(responseCode)) {
            System.out.println("\u001b[31mCannot reactivate EPS as Product Key is already activated on another machine.\u001b[0m");
        } else if ("119".equals(responseCode)) {
            System.out.println("\u001b[31mActivation failed due to invalid input.\u001b[0m");
        } else {
            System.out.println("\u001b[31mActivation failed due to internal error.\u001b[0m");
        }
    }

    private int getOnpremProductType(String productType) {
        int intProductType = 0;
        switch (productType) {
            case "QHBUI": {
                intProductType = 1;
                break;
            }
            case "QHTOT": {
                intProductType = 2;
                break;
            }
            case "QHSME": {
                intProductType = 3;
                break;
            }
            case "QHENT": {
                intProductType = 4;
                break;
            }
            case "QHEDR": {
                intProductType = 5;
                break;
            }
            default: {
                intProductType = 1;
            }
        }
        return intProductType;
    }

    private String getProductTypeOnprem(int prodType) {
        String productType;
        switch (prodType) {
            case 1: {
                productType = "QHBUI";
                break;
            }
            case 2: {
                productType = "QHTOT";
                break;
            }
            case 3: {
                productType = "QHSME";
                break;
            }
            case 4: {
                productType = "QHENT";
                break;
            }
            case 5: {
                productType = "QHEDR";
                break;
            }
            default: {
                productType = "";
            }
        }
        return productType;
    }

    private void updateSSR(UpdateSSR updateSSR) {
        UpdateSSRResponse updateSSRResponse = null;
        String encryptedRequestPayload = null;
        String responseOfOkgCall = "";
        try {
            encryptedRequestPayload = this.phpOp.convertToSecureString(this.objectMapper.writeValueAsString((Object)updateSSR), this.offlineActProperties.getCryptActKey());
        }
        catch (JsonProcessingException e1) {
            System.out.println("Error in parsing: " + (Object)((Object)e1));
        }
        RestTemplate restTemplate = new RestTemplate();
        try {
            responseOfOkgCall = (String)restTemplate.postForObject(this.offlineActProperties.getOkgUpdateSSRApi(), (Object)encryptedRequestPayload, String.class, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("updateSSR: " + e);
        }
        try {
            String response = this.phpOp.convertToPlainString(responseOfOkgCall, this.offlineActProperties.getCryptActKey());
            this.objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            updateSSRResponse = (UpdateSSRResponse)this.objectMapper.readValue(response, UpdateSSRResponse.class);
            switch (updateSSRResponse.getResponseCode()) {
                case "200": {
                    System.out.println("Site License info has been updated successfully for site " + updateSSR.getSiteServerId());
                    break;
                }
                case "99": {
                    System.out.println("\u001b[31mUnable to process your request. Please check your internet connection and try again.\u001b[0m");
                    break;
                }
                case "100": {
                    System.out.println("\u001b[31mInvalid Product Key. Please provide correct Product Key to continue.\u001b[0m");
                    break;
                }
                case "101": {
                    System.out.println("\u001b[31mInvalid Method (Only post call allowed)\u001b[0m");
                    break;
                }
                case "102": {
                    System.out.println("\u001b[31mProduct Key blocked.\u001b[0m");
                    break;
                }
                case "103": {
                    System.out.println("\u001b[31mProduct Key is not registered.\u001b[0m");
                    break;
                }
                case "104": {
                    System.out.println("\u001b[31mSite server details not available on the activation server.\u001b[0m");
                    break;
                }
                case "107": {
                    System.out.println("\u001b[31mDB operation failed while processing Update SSR request.\u001b[0m");
                    break;
                }
                case "116": {
                    System.out.println("\u001b[31mLicense details of '" + updateSSR.getSiteServerId() + "' site server is not available on the activation server." + ANSI_RESET);
                    break;
                }
                default: {
                    System.out.println("\u001b[31mAn internal error occured while updating license details of '" + updateSSR.getSiteServerId() + "' site server on activation server." + ANSI_RESET);
                    break;
                }
            }
        }
        catch (IOException e) {
            System.out.println("licenseSync: " + e);
        }
    }
}

